/*
 * Decompiled with CFR 0.152.
 */
package com.lycanitesmobs.demonmobs.entity;

import com.google.common.base.Predicate;
import com.lycanitesmobs.ObjectManager;
import com.lycanitesmobs.api.IGroupAlpha;
import com.lycanitesmobs.api.IGroupAnimal;
import com.lycanitesmobs.api.IGroupDemon;
import com.lycanitesmobs.api.IGroupHunter;
import com.lycanitesmobs.api.IGroupPredator;
import com.lycanitesmobs.api.IGroupPrey;
import com.lycanitesmobs.core.entity.EntityCreatureAgeable;
import com.lycanitesmobs.core.entity.EntityCreatureRideable;
import com.lycanitesmobs.core.entity.ai.EntityAIAttackMelee;
import com.lycanitesmobs.core.entity.ai.EntityAILookIdle;
import com.lycanitesmobs.core.entity.ai.EntityAIMate;
import com.lycanitesmobs.core.entity.ai.EntityAIPlayerControl;
import com.lycanitesmobs.core.entity.ai.EntityAISwimming;
import com.lycanitesmobs.core.entity.ai.EntityAITargetAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderAttack;
import com.lycanitesmobs.core.entity.ai.EntityAITargetRiderRevenge;
import com.lycanitesmobs.core.entity.ai.EntityAITempt;
import com.lycanitesmobs.core.entity.ai.EntityAIWander;
import com.lycanitesmobs.core.entity.ai.EntityAIWatchClosest;
import com.lycanitesmobs.core.info.DropRate;
import com.lycanitesmobs.core.info.MobInfo;
import com.lycanitesmobs.core.info.ObjectLists;
import java.util.HashMap;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.EnumCreatureAttribute;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityPigZombie;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntityCow;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.MobEffects;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionEffect;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.fml.common.eventhandler.Event;

public class EntityPinky
extends EntityCreatureRideable
implements IAnimals,
IGroupAnimal,
IGroupAlpha,
IGroupPredator,
IGroupHunter,
IGroupDemon {
    EntityAIPlayerControl playerControlAI;

    public EntityPinky(World world) {
        super(world);
        this.attribute = EnumCreatureAttribute.UNDEAD;
        this.defense = 0;
        this.experience = 5;
        this.hasAttackSound = true;
        this.spreadFire = true;
        this.setWidth = 0.9f;
        this.setHeight = 1.95f;
        this.setupMob();
        this.attackTime = 10;
        this.field_70138_W = 1.0f;
    }

    @Override
    protected void func_184651_r() {
        super.func_184651_r();
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming(this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIMate(this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAITempt(this).setItem(new ItemStack(ObjectManager.getItem("pinkytreat"))).setTemptDistanceMin(4.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIAttackMelee(this).setTargetClass(EntityPigZombie.class).setSpeed(1.5).setRate(10).setDamage(8.0).setRange(2.5));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIAttackMelee(this).setSpeed(1.5).setRate(10));
        this.playerControlAI = new EntityAIPlayerControl(this);
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.playerControlAI);
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWander(this).setSpeed(1.0));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new EntityAIWatchClosest(this).setTargetClass(EntityPlayer.class));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new EntityAILookIdle(this));
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAITargetRiderRevenge(this));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAITargetRiderAttack(this));
        this.field_70715_bh.func_75776_a(2, (EntityAIBase)new EntityAITargetRevenge(this).setHelpCall(true));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityCow.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPig.class).setTameTargetting(true));
            this.field_70715_bh.func_75776_a(3, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntitySheep.class).setTameTargetting(true));
        }
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPlayer.class));
        this.field_70715_bh.func_75776_a(4, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityVillager.class));
        this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityPigZombie.class));
        if (MobInfo.predatorsAttackAnimals) {
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAlpha.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupAnimal.class));
            this.field_70715_bh.func_75776_a(5, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(EntityAnimal.class));
        }
        this.field_70715_bh.func_75776_a(6, (EntityAIBase)new EntityAITargetAttack(this).setTargetClass(IGroupPrey.class));
    }

    @Override
    protected void func_110147_ax() {
        HashMap<String, Double> baseAttributes = new HashMap<String, Double>();
        baseAttributes.put("maxHealth", 20.0);
        baseAttributes.put("movementSpeed", 0.24);
        baseAttributes.put("knockbackResistance", 0.25);
        baseAttributes.put("followRange", 16.0);
        baseAttributes.put("attackDamage", 3.0);
        super.applyEntityAttributes(baseAttributes);
    }

    @Override
    public void loadItemDrops() {
        this.drops.add(new DropRate(new ItemStack(ObjectManager.getItem("pinkymeatraw")), 1.0f).setBurningDrop(new ItemStack(ObjectManager.getItem("pinkymeatcooked"))).setMinAmount(1).setMaxAmount(3));
    }

    @Override
    public void func_70636_d() {
        super.func_70636_d();
        if (this.field_70170_p.field_73011_w.getDimension() != -1) {
            this.setFarmed();
        }
    }

    @Override
    public void riderEffects(EntityLivingBase rider) {
        if (rider.func_70644_a(MobEffects.field_82731_v)) {
            rider.func_184589_d(MobEffects.field_82731_v);
        }
        if (rider.func_70027_ad()) {
            rider.func_70015_d(0);
        }
    }

    @Override
    public void mountAbility(Entity rider) {
        if (this.field_70170_p.field_72995_K) {
            return;
        }
        if (this.abilityToggled) {
            return;
        }
        if (this.getStamina() < this.getStaminaCost()) {
            return;
        }
        this.specialAttack();
        this.applyStaminaCost();
    }

    @Override
    public float getStaminaCost() {
        return 20.0f;
    }

    @Override
    public int getStaminaRecoveryWarmup() {
        return 100;
    }

    @Override
    public float getStaminaRecoveryMax() {
        return 1.0f;
    }

    @Override
    public double func_70042_X() {
        return (double)this.field_70131_O * 1.0;
    }

    @Override
    public boolean meleeAttack(Entity target, double damageScale) {
        if (!super.meleeAttack(target, damageScale)) {
            return false;
        }
        if (target instanceof EntityCow || target instanceof EntityPig || target instanceof EntitySheep) {
            this.breed();
        }
        return true;
    }

    public void specialAttack() {
        double distance = 5.0;
        List possibleTargets = this.field_70170_p.func_175647_a(EntityLivingBase.class, this.func_174813_aQ().func_72314_b(distance, distance, distance), (Predicate)new Predicate<EntityLivingBase>(){

            public boolean apply(EntityLivingBase possibleTarget) {
                return possibleTarget.func_70089_S() && possibleTarget != EntityPinky.this && !EntityPinky.this.func_184215_y((Entity)possibleTarget) && !EntityPinky.this.func_184191_r((Entity)possibleTarget) && EntityPinky.this.func_70686_a(possibleTarget.getClass()) && EntityPinky.this.canAttackEntity(possibleTarget);
            }
        });
        if (!possibleTargets.isEmpty()) {
            for (EntityLivingBase possibleTarget : possibleTargets) {
                boolean doDamage = true;
                if (this.getRider() instanceof EntityPlayer && MinecraftForge.EVENT_BUS.post((Event)new AttackEntityEvent((EntityPlayer)this.getRider(), (Entity)possibleTarget))) {
                    doDamage = false;
                }
                if (!doDamage) continue;
                possibleTarget.func_70690_d(new PotionEffect(MobEffects.field_82731_v, 200, 0));
            }
        }
        this.playAttackSound();
        this.setJustAttacked();
    }

    @Override
    public boolean canBeTempted() {
        return this.func_70631_g_();
    }

    @Override
    public int getNoBagSize() {
        return 0;
    }

    @Override
    public int getBagSize() {
        return 10;
    }

    @Override
    public boolean func_70687_e(PotionEffect potionEffect) {
        if (potionEffect.func_188419_a() == MobEffects.field_82731_v) {
            return false;
        }
        super.func_70687_e(potionEffect);
        return true;
    }

    @Override
    public boolean canBurn() {
        return false;
    }

    @Override
    public float getFallResistance() {
        return 10.0f;
    }

    @Override
    public EntityCreatureAgeable createChild(EntityCreatureAgeable baby) {
        return new EntityPinky(this.field_70170_p);
    }

    @Override
    public boolean isBreedingItem(ItemStack itemStack) {
        if (!MobInfo.predatorsAttackAnimals) {
            return ObjectLists.inItemList("rawmeat", itemStack) || ObjectLists.inItemList("cookedmeat", itemStack);
        }
        return false;
    }

    @Override
    public boolean isTamingItem(ItemStack itemstack) {
        return itemstack.func_77973_b() == ObjectManager.getItem("pinkytreat") && this.func_70631_g_();
    }

    @Override
    public boolean isHealingItem(ItemStack testStack) {
        return ObjectLists.inItemList("CookedMeat", testStack);
    }
}

